from django.urls import path
from .views import ScheduleListCreateAPIView, DoctorScheduleAPIView, BookAppointmentView, PatientAppointmentsView, DoctorAppointmentsView, AcceptAppointmentAPIView, RejectAppointmentAPIView

app_name = 'appointments'

urlpatterns = [
    path('doctor/', ScheduleListCreateAPIView.as_view(), name='schedule-list-create'),
    path('doctors/<int:doctor_id>/schedule/', DoctorScheduleAPIView.as_view(), name='doctor-schedule'),
    path('doctors/<int:doctor_id>/book/', BookAppointmentView.as_view(), name='book-appointment'),
    path('patient/', PatientAppointmentsView.as_view(), name='patient-appointments'),
    path('doctor/list/', DoctorAppointmentsView.as_view(), name='doctors-appointments'),
    path('<int:app_id>/accept/', AcceptAppointmentAPIView.as_view(), name='accept'),
    path('<int:app_id>/reject/', RejectAppointmentAPIView.as_view(), name='reject'),
]
