from django.db import models
from apps.doctor.models import Doctor
from apps.patient.models import Patient

class DoctorSchedule(models.Model):
    REPEAT_CHOICES = (
        ('none', 'هیچ'),
        ('weekly', 'هفتگی'),
        ('daily', 'روزانه'),
        ('daily_except_friday', 'روزانه به جز جمعه'),
        ('every_other_day_except_friday', 'یک روز در میان به جز جمعه'),
        ('every_other_day', 'یک روز در میان'),
        ('every_other_week', 'یک هفته در میان'),
    )
    doctor = models.ForeignKey(Doctor, related_name='schedule_records', on_delete=models.CASCADE)
    start_time = models.TimeField()
    end_time = models.TimeField()
    date = models.DateField()
    batch_id = models.UUIDField()
    # repeat = models.CharField(max_length=30,choices=REPEAT_CHOICES,default='none')
    # records = models.JSONField(default=list)
    time_slots = models.JSONField(default=list,null=True,blank=True)    
    created_at=models.DateTimeField(auto_now_add=True)
    updated_at=models.DateTimeField(auto_now=True)
    
    class Meta:
        ordering = ("created_at",)

    def __str__(self):
           return f" Dr {self.doctor.user.mobile_phone} is free on {self.date}"
        
# class Record(models.Model):
#     appointment = models.ForeignKey(DoctorAppointment, related_name='records', on_delete=models.CASCADE)
#     start_time = models.TimeField()
#     end_time = models.TimeField()

#     def __str__(self):
#         return f"Record: {self.start_time} - {self.end_time}"


class PatientAppointment(models.Model):
    doctor = models.ForeignKey(Doctor, on_delete=models.CASCADE,related_name="doctor_appointments")
    patient = models.ForeignKey(Patient, on_delete=models.CASCADE, related_name="patient_appointments")
    patient_name = models.CharField(max_length=250, blank=True, null=True)
    datetime = models.DateTimeField()
    self_reserved = models.BooleanField(default=False)
    created_at=models.DateTimeField(auto_now_add=True)
    updated_at=models.DateTimeField(auto_now=True)
    accepted = models.BooleanField(blank=True, null=True)

    class Meta:
        ordering = ("created_at",)

    def __str__(self):
           return f'{self.patient_name}'
        
    