from uuid import uuid4
from jdatetime import date as JalaliDate
from .models import DoctorSchedule

def get_last_day_of_year(jalali_date):
    if JalaliDate.isleap(jalali_date.year):
        last_day = JalaliDate(jalali_date.year, 12, 30)
    else:
        last_day = JalaliDate(jalali_date.year, 12, 29)
    return last_day

def days_until_end_of_jalali_year(jalali_str):
    try:
        user_date = JalaliDate(year=int(jalali_str[:4]), month=int(jalali_str[4:6]), day=int(jalali_str[6:8]))
    except:
        raise ValueError("Invalid date format supplied")
 
    last_day = get_last_day_of_year(user_date)
    
    return (last_day - user_date).days

def generate_batch_id():
    id = uuid4()
    while DoctorSchedule.objects.filter(batch_id=id).exists():
        id = uuid4()
    return id
