from rest_framework import serializers
from apps.core.models import File

class FileSerializer(serializers.ModelSerializer):
    class Meta:
        model = File
        fields = '__all__'
        extra_kwargs = {
            'user': {'read_only': True}
        }

    def create(self, validated_data):
        user = self.context['request'].user
        # Retrieve all uploaded files from the request
        files = self.context['request'].FILES.getlist('file')

        # Iterate through each file and create a File object for each one
        created_files = []
        for file in files:
            file_instance = File.objects.create(file=file, user=user)
            created_files.append(file_instance)

        return created_files