from django.urls import path, include
from .views import FileUploadView

app_name = 'core'

urlpatterns = [
    path('file-upload/', FileUploadView.as_view(), name='file-upload'),
    path('doctor/', include('apps.doctor.api.v1.urls', namespace='doctor')),
    path('patient/', include('apps.patient.api.v1.urls', namespace='patient')),
    path('referral/', include('apps.referral.api.v1.urls', namespace='referral')),
    path('tamin/', include('apps.tamin.urls', namespace='tamin')),
    path('notification/', include('apps.notification.api.v1.urls', namespace='notification')),
    path('appointments/', include('apps.appointments.api.v1.urls', namespace='appointments')),
]