from rest_framework.views import APIView
from rest_framework.permissions import IsAuthenticated
from rest_framework.response import Response
from rest_framework import status
from .serializers import FileSerializer

class FileUploadView(APIView):
    permission_classes = [IsAuthenticated]

    def post(self, request, *args, **kwargs):
        # Create a copy of the data and initialize the serializer
        serializer = FileSerializer(data=request.data, context={'request': self.request})

        if serializer.is_valid():
            
            created_files = serializer.save()
            files=[]
            for file in created_files:
                files.append({
               "user_id": request.user.id,
               "file_id": file.id,
                "file_url": file.file.url
                 })
            return Response({"files": files }, status=status.HTTP_201_CREATED)
        return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)