import uuid
from django.db import models


def file_upload_to(instance, filename):
    # Generate a unique filename
    splited_filename = filename.split('.')
    if len(splited_filename) > 1:
        new_filename = f"{uuid.uuid4()}.{splited_filename[-1]}"
    else:
        new_filename = f"{uuid.uuid4()}"
    return f"uploads/{new_filename}"

class File(models.Model):
    file = models.FileField(upload_to=file_upload_to)
    user = models.ForeignKey('user.User', on_delete=models.CASCADE)
    uploaded_at = models.DateTimeField(auto_now_add=True)
    
    def __str__(self):
        # Check if the file exists before accessing its URL
        if self.file:
            return self.file.url
        return "No file uploaded"

    def delete(self, *args, **kwargs):
        # Delete the file from storage before deleting the model instance
        if self.file:
            self.file.delete(save=False)
        super().delete(*args, **kwargs)