import requests
from django.conf import settings



def send_sms(mobile_phone, code):
    base_url = "https://api.kavenegar.com/v1/{}/verify/lookup.json".format(settings.KAVENEGAR_API_KEY)
    params = {
        "receptor": mobile_phone,
        "token": code,
        "template": "verify"
    }
    try:
        response = requests.get(base_url, params=params, timeout=10)
        return response.json()
    except Exception as e:
        print(f"Error sending SMS: {e}")
        return False
