from django.urls import path
from rest_framework_simplejwt.views import TokenRefreshView
from .views import (SignUp_Login, UserVerifyCodeAPIView, VerifyOtpReferralAPIView,
                    PrivateProfileAPIView, PublicProfileAPIView, DoctorSearchAPIView, 
                    WorkRecordAPIView, WorkRecordDetailAPIView, EducationHistoryAPIView,
                    EducationHistoryDetailAPIView, CertificateAPIView, 
                    CertificateDetailAPIView, AwardAPIView, 
                    AwardDetailAPIView, DoctorPatientsListView, )

app_name = 'doctor'

urlpatterns = [
    path("signup-login/", SignUp_Login.as_view(), name="signup-login"),
    path("verify-referral-otp/", VerifyOtpReferralAPIView.as_view(), name="verify-referral-code"),
    path("verify-code/", UserVerifyCodeAPIView.as_view(), name="verify-code"),
    path("token/refresh/", TokenRefreshView.as_view(), name="token-refresh"),
    path('private-profile/', PrivateProfileAPIView.as_view(), name='private-profile'),
    path('public-profile/<int:doctor_id>/', PublicProfileAPIView.as_view(), name='public-profile'),
    path('search/', DoctorSearchAPIView.as_view(), name='search'),
    path('work-record/', WorkRecordAPIView.as_view(), name='work-record'), 
    path('work-record/<int:work_record_id>/', WorkRecordDetailAPIView.as_view(), name='work-record-detail'),
    path('education-history/', EducationHistoryAPIView.as_view(), name='education-history'), 
    path('education-history/<int:education_history_id>/', EducationHistoryDetailAPIView.as_view(), name='education-history-detail'),
    path('certificate/', CertificateAPIView.as_view(), name='certificate'), 
    path('certificate/<int:certificate_id>/', CertificateDetailAPIView.as_view(), name='certificate-detail'),
    path('award/', AwardAPIView.as_view(), name='awaed'), 
    path('award/<int:award_id>/', AwardDetailAPIView.as_view(), name='award-detail'),
    path('patients/', DoctorPatientsListView.as_view(), name='patients'),
]
