from django.utils import timezone
from rest_framework import status
from rest_framework.permissions import IsAuthenticated
from rest_framework.response import Response
from rest_framework.views import APIView
from rest_framework.response import Response
from .serializers import NotificationSerializer, ReadNotificationsSerializer
from apps.notification.models import Notification


class NotificationsView(APIView):
    permission_classes = [IsAuthenticated]
    def get(self, request, *args, **kwargs):
        user = request.user
        notifications = Notification.objects.filter(recipient=user)
        is_read = request.query_params.get('is_read', None)
        if is_read and is_read == 'true':
            notifications = notifications.filter(is_read=True)
        elif is_read == 'false':
            notifications = notifications.filter(is_read=False)
        serializer = NotificationSerializer(notifications, many=True, context={'request': request})
        return Response(serializer.data, status=status.HTTP_200_OK)


class ReadNotificationsView(APIView):
    permission_classes = [IsAuthenticated]
    def post(self, request, *args, **kwargs):
        serializer = ReadNotificationsSerializer(data=request.data, context={'request': request})
        if serializer.is_valid():
            notification_ids = serializer.validated_data['notification_ids']
            Notification.objects.filter(pk__in=notification_ids, recipient=request.user).update(
                is_read=True, 
                seen_time=timezone.now()
            )
            return Response(serializer.data, status=status.HTTP_200_OK)
        return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)

