from django.contrib.auth import get_user_model
from django.db import models
from django.utils import timezone

User = get_user_model()

class Notification(models.Model):
    recipient = models.ForeignKey(User, on_delete=models.CASCADE, related_name='notifications')
    title = models.CharField(max_length=255)
    message = models.TextField()
    is_read  =models.BooleanField(default=False)
    seen_time = models.DateTimeField(blank=True, null=True)
    created_at = models.DateTimeField(auto_now_add=True)

    def __str__(self):
        return f"{self.message} -> {self.recipient.mobile_phone}"
    
    def mark_as_read(self):
        if not self.is_read:
            self.is_read = True
            self.seen_time = timezone.now()
            self.save()
    
    class Meta:
        ordering = ['-created_at']