from django.urls import path
from rest_framework_simplejwt.views import TokenRefreshView
from .views import (SignUp_Login, UserVerifyCodeAPIView, PatientApiView, PatientsDefaultDossierAPIView,
                    DossierSearchAPIView, DossierApiview, UserDoctorDossierApiView, 
                    UserPatientDossierApiView, VisitDossierApiView, VisitApiView, DossierNotesAPIView,
                    GetPatientPublicAPIView,)

app_name = 'patient'

urlpatterns = [
    path("signup-login/", SignUp_Login.as_view(), name="signup-login"),
    path("verify/", UserVerifyCodeAPIView.as_view(), name="verify-code"),
    path("token/refresh/", TokenRefreshView.as_view(), name="token-refresh"),
    path('profile/personal-info/', PatientApiView.as_view(), name='profile'),
    path('profile/default-dossier/', PatientsDefaultDossierAPIView.as_view(), name='profie-dossier'),
    path('dossier/search/', DossierSearchAPIView.as_view(), name="search-dossier"),
    path('dossier/', DossierApiview.as_view(), name='dossier'),
    path('dossier/<int:dossier_pk>/', DossierApiview.as_view(), name='detail-dossier'),
    path('doctor_dossier/', UserDoctorDossierApiView.as_view(), name='doctor_dossier'),
    path('patient_dossier/', UserPatientDossierApiView.as_view(), name='patient_dossier'),
    path('visit/', VisitDossierApiView.as_view(), name='dossier_visit'),
    path('dossier/<str:dossier_pk>/visit/', VisitApiView.as_view(), name='dossier_visit'),
    path('dossier/<str:dossier_pk>/visit/<int:visit_pk>/', VisitApiView.as_view(), name='dossier_visit'),
    path('dossier/<int:dossier_id>/notes/', DossierNotesAPIView.as_view(), name="note-history"),
    path('<int:patient_id>/', GetPatientPublicAPIView.as_view(), name='public-profile'),
]
