from django.db import models
from apps.doctor.models import Doctor
from apps.patient.models import Patient, Dossier

class Referral(models.Model):
    patient = models.ForeignKey(Patient, on_delete=models.CASCADE, related_name='patient_referral')
    from_doctor = models.ForeignKey(Doctor, on_delete=models.CASCADE, related_name='referral_from_doctor')
    to_doctor = models.ForeignKey(Doctor, on_delete=models.CASCADE, related_name='to_doctor_referral')
    dossier = models.ForeignKey(Dossier, on_delete=models.CASCADE, related_name='referral_dossier')
    reason = models.CharField(max_length=250)
    reason_detail = models.TextField(blank=True, null=True)
    is_active = models.BooleanField(default=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self):
        return f'{self.reason}'


class ReferralTherapyNotes(models.Model):
    note = models.TextField()
    referral = models.ForeignKey(Referral, on_delete=models.PROTECT, related_name='referral_therapy_notes')
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self):
        return self.note
