# Generated by Django 5.2.1 on 2025-06-09 03:11

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Complaint',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('icd_id', models.CharField(max_length=20)),
                ('icd_code', models.CharField(max_length=20)),
                ('icd_name', models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='DrugAmount',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=100)),
                ('summary', models.TextField(blank=True, null=True)),
                ('latin', models.CharField(blank=True, max_length=100, null=True)),
                ('concept', models.CharField(max_length=255)),
                ('visible', models.CharField(blank=True, max_length=8, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='DrugInstruction',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=20)),
                ('summary', models.TextField(blank=True, null=True)),
                ('latin', models.TextField(blank=True, null=True)),
                ('concept', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='DrugUsage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=20)),
                ('summary', models.TextField(blank=True, null=True)),
                ('latin', models.TextField(blank=True, null=True)),
                ('concept', models.CharField(max_length=255)),
                ('visible', models.CharField(blank=True, max_length=8, null=True)),
                ('drug_form_code', models.CharField(blank=True, max_length=20, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='ICD10Code',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.IntegerField()),
                ('display_name', models.CharField(max_length=255)),
                ('english_name', models.CharField(max_length=255)),
                ('terminology', models.CharField(max_length=50)),
                ('status', models.CharField(max_length=8)),
            ],
        ),
        migrations.CreateModel(
            name='Illness',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('desc', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='MedicalSpecialty',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=20)),
                ('desc', models.CharField(max_length=255)),
                ('grp', models.CharField(max_length=20)),
                ('doc_comment', models.TextField(blank=True, null=True)),
                ('status', models.CharField(max_length=8)),
                ('status_date', models.CharField(max_length=10)),
                ('type_spec', models.CharField(blank=True, max_length=20, null=True)),
                ('max_normal', models.IntegerField(blank=True, null=True)),
                ('max_special', models.IntegerField(blank=True, null=True)),
                ('l_status', models.CharField(max_length=8)),
            ],
        ),
        migrations.CreateModel(
            name='ParTarefValue',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('grp_code', models.CharField(max_length=8)),
                ('grp_desc', models.CharField(max_length=120)),
                ('grp_rem', models.CharField(max_length=8)),
                ('status', models.CharField(max_length=8)),
                ('status_date', models.CharField(max_length=10)),
            ],
        ),
        migrations.CreateModel(
            name='PrescriptionType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=8)),
                ('desc', models.CharField(blank=True, max_length=120, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Service',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('srv_id', models.CharField(blank=True, max_length=20, null=True)),
                ('srv_type', models.JSONField(default=dict)),
                ('srv_code', models.CharField(blank=True, max_length=20, null=True)),
                ('name', models.TextField(blank=True, null=True)),
                ('name2', models.CharField(blank=True, max_length=500, null=True)),
                ('bim_sw', models.CharField(blank=True, max_length=500, null=True)),
                ('sex', models.CharField(blank=True, max_length=8, null=True)),
                ('price', models.CharField(blank=True, max_length=120, null=True)),
                ('price_date', models.CharField(blank=True, max_length=15, null=True)),
                ('dose_code', models.CharField(blank=True, max_length=500, null=True)),
                ('form_code', models.CharField(blank=True, max_length=500, null=True)),
                ('par_taref_group', models.JSONField(blank=True, default=dict, null=True)),
                ('status', models.CharField(blank=True, max_length=500, null=True)),
                ('status_date', models.CharField(blank=True, max_length=500, null=True)),
                ('bg_type', models.CharField(blank=True, max_length=500, null=True)),
                ('gsrv_code', models.CharField(blank=True, max_length=500, null=True)),
                ('agreement_flag', models.CharField(blank=True, max_length=500, null=True)),
                ('is_deleted', models.CharField(blank=True, max_length=500, null=True)),
                ('visible', models.CharField(blank=True, max_length=500, null=True)),
                ('dental_service_type', models.CharField(blank=True, max_length=500, null=True)),
                ('ws_srv_code', models.CharField(blank=True, max_length=500, null=True)),
                ('hos_presc_type', models.CharField(blank=True, max_length=500, null=True)),
                ('srv_rule', models.CharField(blank=True, max_length=500, null=True)),
                ('count_is_restricted', models.CharField(blank=True, max_length=500, null=True)),
                ('terminology', models.CharField(blank=True, max_length=500, null=True)),
                ('srv_code_complete', models.CharField(blank=True, max_length=500, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='ServiceType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=8)),
                ('desc', models.CharField(blank=True, max_length=120, null=True)),
                ('status', models.CharField(blank=True, max_length=8, null=True)),
                ('status_date', models.CharField(blank=True, max_length=10, null=True)),
                ('cost_type', models.CharField(blank=True, max_length=8, null=True)),
                ('presc_type_id', models.IntegerField(blank=True, null=True)),
                ('head_expire_date', models.IntegerField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='TreatmentPlan',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('desc', models.CharField(max_length=120)),
                ('code', models.CharField(max_length=20)),
            ],
        ),
        migrations.CreateModel(
            name='AuthCodes',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code_verifier', models.CharField(max_length=255)),
                ('code_challenge', models.CharField(max_length=255)),
                ('access_token', models.CharField(blank=True, max_length=2000, null=True)),
                ('access_token_expires_at', models.DateTimeField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='NoteDetailEprsc',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('srv_qty', models.IntegerField()),
                ('dose', models.CharField(blank=True, max_length=64, null=True)),
                ('repeat', models.CharField(blank=True, max_length=32, null=True)),
                ('date_do', models.CharField(blank=True, max_length=10, null=True)),
                ('reference_status', models.IntegerField(blank=True, null=True)),
                ('is_dental_service', models.CharField(blank=True, max_length=8, null=True)),
                ('tooth_id', models.CharField(blank=True, max_length=16, null=True)),
                ('note_details_eprsc_id', models.IntegerField(blank=True, null=True)),
                ('drug_instruction', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='tamin.druginstruction')),
                ('illness', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='tamin.illness')),
                ('times_a_day', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='tamin.drugamount')),
                ('srv', models.ForeignKey(on_delete=django.db.models.deletion.RESTRICT, to='tamin.service')),
                ('plan', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='tamin.treatmentplan')),
            ],
        ),
        migrations.CreateModel(
            name='NoteDetailsReferral',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('referral_hijri_date', models.CharField(max_length=10)),
                ('patient_national_code', models.CharField(max_length=20)),
                ('message', models.TextField()),
                ('quantity', models.IntegerField()),
                ('complaints', models.ManyToManyField(to='tamin.complaint')),
                ('doc_spec_referred', models.ForeignKey(on_delete=django.db.models.deletion.RESTRICT, to='tamin.medicalspecialty')),
                ('icd10s', models.ManyToManyField(to='tamin.icd10code')),
            ],
        ),
        migrations.CreateModel(
            name='Prescription',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('head_id', models.CharField(max_length=120, unique=True)),
                ('patient', models.CharField(max_length=20)),
                ('presc_date', models.CharField(max_length=10)),
                ('expire_date', models.CharField(max_length=10)),
                ('doc_id', models.CharField(max_length=20)),
                ('doc_national_code', models.CharField(max_length=20)),
                ('doc_mobile_no', models.CharField(max_length=20)),
                ('comments', models.TextField(blank=True, null=True)),
                ('referral_feedback_id', models.IntegerField(blank=True, null=True)),
                ('client_id', models.CharField(blank=True, max_length=64, null=True)),
                ('siam_id', models.CharField(blank=True, max_length=64, null=True)),
                ('creator_type', models.CharField(blank=True, max_length=32, null=True)),
                ('doctor_user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='doctor_tamin_prescriptions', to=settings.AUTH_USER_MODEL)),
                ('note_detail_eprscs', models.ManyToManyField(blank=True, to='tamin.notedetaileprsc')),
                ('note_details_referral_list', models.ManyToManyField(blank=True, to='tamin.notedetailsreferral')),
                ('patient_user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='tamin_prescriptions', to=settings.AUTH_USER_MODEL)),
                ('presc_type', models.ForeignKey(on_delete=django.db.models.deletion.RESTRICT, to='tamin.prescriptiontype')),
            ],
        ),
        migrations.AddField(
            model_name='service',
            name='service_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='services', to='tamin.servicetype'),
        ),
    ]
