from rest_framework import serializers
from .models import (PrescriptionType, ServiceType, DrugInstruction,
                     ParTarefValue, DrugAmount, DrugUsage,
                     TreatmentPlan, Illness, Complaint, ICD10Code, MedicalSpecialty, Service,
                     Prescription, NoteDetailEprsc, NoteDetailsReferral)

class PrescriptionTypeSerializer(serializers.ModelSerializer):
    class Meta:
        model = PrescriptionType
        fields = '__all__'

class ServiceTypeSerializer(serializers.ModelSerializer):
    class Meta:
        model = ServiceType
        fields = '__all__'

class DrugInstructionSerializer(serializers.ModelSerializer):
    class Meta:
        model = DrugInstruction
        fields = '__all__'

class ParTarefValueSerializer(serializers.ModelSerializer):
    class Meta:
        model = ParTarefValue
        fields = '__all__'

class DrugAmountSerializer(serializers.ModelSerializer):
    class Meta:
        model = DrugAmount
        fields = '__all__'

class DrugUsageSerializer(serializers.ModelSerializer):
    class Meta:
        model = DrugUsage
        fields = '__all__'

class TreatmentPlanSerializer(serializers.ModelSerializer):
    class Meta:
        model = TreatmentPlan
        fields = '__all__'

class IllnessSerializer(serializers.ModelSerializer):
    class Meta:
        model = Illness
        fields = '__all__'

class ComplaintSerializer(serializers.ModelSerializer):
    class Meta:
        model = Complaint
        fields = '__all__'

class ICD10CodeSerializer(serializers.ModelSerializer):
    class Meta:
        model = ICD10Code
        fields = '__all__'

class MedicalSpecialtySerializer(serializers.ModelSerializer):
    class Meta:
        model = MedicalSpecialty
        fields = '__all__'

class ServiceSerializer(serializers.ModelSerializer):
    class Meta:
        model = Service
        fields = '__all__'
        depth = 1

class NoteDetailEprscSerializer(serializers.ModelSerializer):
    srv = serializers.PrimaryKeyRelatedField(queryset=Service.objects.all())
    times_a_day = serializers.PrimaryKeyRelatedField(queryset=DrugAmount.objects.all(), required=False)
    drug_instruction = serializers.PrimaryKeyRelatedField(queryset=DrugInstruction.objects.all(), required=False)
    illness = serializers.PrimaryKeyRelatedField(queryset=Illness.objects.all(), required=False)
    plan = serializers.PrimaryKeyRelatedField(queryset=TreatmentPlan.objects.all(), required=False)
    class Meta:
        model = NoteDetailEprsc
        fields = '__all__'
        depth = 1

class NoteDetailsReferralSerializer(serializers.ModelSerializer):
    doc_spec_referred = serializers.PrimaryKeyRelatedField(queryset=MedicalSpecialty.objects.all())
    icd10s = serializers.PrimaryKeyRelatedField(queryset=ICD10Code.objects.all(), many=True)
    complaints = serializers.PrimaryKeyRelatedField(queryset=Complaint.objects.all(), many=True)

    class Meta:
        model = NoteDetailsReferral
        fields = '__all__'
        depth = 1

    def to_representation(self, instance):
        rep = super().to_representation(instance)
        rep['doc_spec_referred'] = MedicalSpecialtySerializer(instance.doc_spec_referred).data
        rep['icd10s'] = ICD10CodeSerializer(instance.icd10s.all(), many=True).data
        rep['complaints'] = ComplaintSerializer(instance.complaints.all(), many=True).data
        return rep

class PrescriptionSerializer(serializers.ModelSerializer):
    note_detail_eprscs = NoteDetailEprscSerializer(many=True, required=False)
    note_details_referral_list = NoteDetailsReferralSerializer(many=True, required=False)
    head_id = serializers.CharField(read_only=True)
    presc_type = serializers.PrimaryKeyRelatedField(queryset=PrescriptionType.objects.all())
    class Meta:
        model = Prescription
        fields = '__all__'
        depth = 1

    def create(self, validated_data):
        print(validated_data)
        note_detail_eprscs_data = validated_data.pop('note_detail_eprscs', [])
        note_details_referral_list_data = validated_data.pop('note_details_referral_list', [])
        prescription = Prescription.objects.create(**validated_data)
        for eprsc_data in note_detail_eprscs_data:
            eprsc = NoteDetailEprsc.objects.create(**eprsc_data)
            prescription.note_detail_eprscs.add(eprsc)
        for referral_data in note_details_referral_list_data:
            icd10s = referral_data.pop('icd10s', [])
            complaints = referral_data.pop('complaints', [])
            referral = NoteDetailsReferral.objects.create(**referral_data)
            referral.icd10s.set(icd10s)
            referral.complaints.set(complaints)
            prescription.note_details_referral_list.add(referral)
        return prescription

    def to_representation(self, instance):
        rep = super().to_representation(instance)
        rep['note_detail_eprscs'] = NoteDetailEprscSerializer(instance.note_detail_eprscs.all(), many=True).data
        rep['note_details_referral_list'] = NoteDetailsReferralSerializer(instance.note_details_referral_list.all(), many=True).data
        return rep
