from django.urls import path
from .views import (AuthenticateAPIView, AuthenticateURLView,
                    CheckPatientCredability, PrescriptionTypeListView,
                    ServiceTypeListView, DrugInstructionListView,
                    ParTarefValueListView, DrugAmountListView,
                    DrugUsageListView, TreatmentPlanListView, IllnessListView,
                    ComplaintListView, ICD10CodeListView, MedicalSpecialtyListView, ServiceListView,
                    PrescriptionCreateView, CheckUserTaminToken,)

app_name = "tamin"

urlpatterns = [
    path("auth_url/", AuthenticateURLView.as_view(), name="auth_url"),
    path("authenticate/", AuthenticateAPIView.as_view(), name="authenticate"),
    path("patient-check/<str:patient_id>/", CheckPatientCredability.as_view(), name="paitent-credability-check"),
    path('basic-data/prescription-types/', PrescriptionTypeListView.as_view(), name='prescription-type-list'),
    path('basic-data/service-types/', ServiceTypeListView.as_view(), name='service-type-list'),
    path('basic-data/drug-instructions/', DrugInstructionListView.as_view(), name='drug-instruction-list'),
    path('basic-data/par-taref-values/', ParTarefValueListView.as_view(), name='par-taref-value-list'),
    path('basic-data/drug-amounts/', DrugAmountListView.as_view(), name='drug-amount-list'),
    path('basic-data/drug-usages/', DrugUsageListView.as_view(), name='drug-usage-list'),
    path('basic-data/treatment-plans/', TreatmentPlanListView.as_view(), name='treatment-plan-list'),
    path('basic-data/illnesses/', IllnessListView.as_view(), name='illness-list'),
    path('basic-data/complaints/', ComplaintListView.as_view(), name='complaint-list'),
    path('basic-data/icd10-codes/', ICD10CodeListView.as_view(), name='icd10code-list'),
    path('basic-data/medical-specialties/', MedicalSpecialtyListView.as_view(), name='medical-specialty-list'),
    path('basic-data/services/<int:service_type_id>/', ServiceListView.as_view(), name='service-list'),
    path('prescription/create/', PrescriptionCreateView.as_view(), name='prescription-create'),
    path('check-token/', CheckUserTaminToken.as_view(), name='check-tamin-token'),
]
